var fontFamily = null;
var fontSize = null;
var fontStyle = null;
var fontWeight = null;
var defaultColor = null;
var defaultBGColor = null;
var defaultBorderColor = null;
var selectedColor = null;
var selectedBGColor = null;
var hoverColor = null;
var hoverBGColor = null;
var selectedHoverColor = null;
var selectedHoverBGColor = null;
var tableFontFamily = null;
var tableFontSize = null;
var tableFontStyle = null;
var tableFontWeight = null;
var tableDefaultColor = null;
var tableDefaultBGColor = null;
var tableHeaderColor = null;
var tableHeaderBGColor = null;
var tableSelectedColor = null;
var tableSelectedBGColor = null;
var tableTooltipTextColor = null;
var tableTooltipColor = null;
var tableTooltipBGColor = null;
var tableInactiveLineColor = null;
var tableInactiveLineBGColor = null;
var treeFontFamily = null;
var treeFontSize = null;
var treeFontStyle = null;
var treeFontWeight = null;
var treeDefaultColor = null;
var treeDefaultBGColor = null;
var treeSelectedColor = null;
var treeSelectedBGColor = null;
var treeHoverColor = null;
var treeHoverBGColor = null;
var treeHoverSelectedColor = null;
var treeHoverSelectedBGColor = null;
var treeBackgroundImage = null;
var treeBackgroundAttachment = null;
var treeBackgroundRepeat = null;
var imageViewFontFamily = null;
var imageViewFontSize = null;
var imageViewFontStyle = null;
var imageViewFontWeight = null;
var imageViewColor = null;
var imageViewBGColor = null;
var headerColor = null;
var headerBGColor = null;
var overviewBoxColor = null;
var overviewBoxBorderColor = null;
var overviewFrameColor = null;
var hintBGColor = null;
var hintColor = null;
var hintTextColor = null;
var hotspotColor = null;
var hoverHotspotColor = null;
var alwaysHotspotColor = null;
var tableGridColor = null;
var tableHeaderGridColor = null;
var dividerColor = null;
var filterFontFamily = null;
var filterFontSize = null;
var filterFontStyle = null;
var filterFontWeight = null;
var filterBGColor = null;
var filterFGColor = null;
var filterHoverBGColor = null;
var filterUnderlineOnHover = null;
var filterButtonBGColor = null;
var filterButtonFGColor = null;
var filterButtonBorderColor = null;

var colors = new Array();
colors["black"] = "#000000";
colors["green"] = "#008000";
colors["silver"] = "#c0c0c0";
colors["lime"] = "#00ff00";
colors["gray"] = "#808080";
colors["olive"] = "#808000";
colors["white"] = "#ffffff";
colors["yellow"] = "#ffff00";
colors["maroon"] = "#800000";
colors["navy"] = "#000080";
colors["red"] = "#ff0000";
colors["blue"] = "#0000ff";
colors["purple"] = "#800080";
colors["teal"] = "#008080";
colors["fuchsia"] = "#ff00ff";
colors["aqua"] = "#00ffff";

function getWebColor(color) {
	if (color == null || color == '') return null; // color undefined
	if (color.toLowerCase() == "transparent") return 'null'; // transparent color
	var namedColor = colors[color.toLowerCase()];
	if (namedColor != null) return namedColor;
	else if (browserName == "Internet Explorer" || browserName == "Konqueror") {
	  if (color.length > 7) return color.substring(0, 7);
	  else return color;
	} else {
		color = color.substring(4, color.length - 1);
		var rgb = color.split(',');
		var c = "#";
		for (var i = 0; i < 3; i++) {
			var tmp = parseInt(rgb[i]).toString(16);
			if (tmp.length < 2) tmp = '0' + tmp;
			c += tmp;
		}
		return c;
	}
}
function getFontSize(str) {
	if (str == null || str == "") return null;
	if (str.substring(str.length - 2) == 'px') return str.substring(0, str.length - 2);
	else return str;
}
function getFontFamily(str) {
	if (str == null || str == '') return null;
	else {
		str = str.replace(/Sans-Serif/gi, "SansSerif");
		return str.replace(/Monospace/gi, "MonoSpaced");
	}
}
function getBelFontStyle(cssFontStyle, cssFontWeight) {
	if (cssFontStyle != "italic" && cssFontWeight != "bold") return "plain";
	else if (cssFontStyle == "italic") {
		if (cssFontWeight == "bold") return "bold+italic";
		else return "italic";
	} else return "bold";
}
function nullify(str) {
	if (str == '') return null;
	else return str;
}
function translateSelector(selector) {
  var newSelector = selector;
  if (selector.length > 0) {
    if (selector.charAt(0) != "." && selector.charAt(0) != "#") {
      if (browserName == "Internet Explorer") {
        newSelector = selector.charAt(0) == '*' ? selector.substring(1) : selector.toUpperCase();
        if(browserVersion >= 7 && selector.charAt(0) == "*") newSelector = "*";
      } else newSelector = selector.toLowerCase();
    }
  }
  return newSelector;
}

function getCSSProperty(doc, selector, key) {
  if (!doc.styleSheets) return null;
  
  selector = translateSelector(selector).toLowerCase();
  
  var dSS = doc.styleSheets;
  for(var i = 0; i < dSS.length; i++) {
    var Rules;
    if (dSS[i].cssRules) Rules = dSS[i].cssRules;
    else if (dSS[i].rules) Rules = dSS[i].rules;
    else return null;
    for(var j = 0; j < Rules.length; j++) {
      if(Rules[j].selectorText.toLowerCase() == selector) {
        return Rules[j].style[key];
      }
    }
  }
  return null;
}

function setCSSProperty(doc, selector, key, value) {
  if (!doc.styleSheets) return;

  selector = translateSelector(selector);

	var dSS = doc.styleSheets;
	var setRule = false;
	for(var i = 0; i < dSS.length; i++) {
		var Rules;
    if (dSS[i].cssRules) Rules = dSS[i].cssRules;
    else if (dSS[i].rules) Rules = dSS[i].rules;
    else return;
		for(var j = 0; j < Rules.length; j++) {
			if(Rules[j].selectorText == selector) {
				Rules[j].style[key] = value;
				setRule = true;
			}
		}
	}
	if (!setRule) {
    if(browserName == "Internet Explorer") dSS[0].addRule(selector, key + ":" + value);
    else dSS[0].insertRule(selector + ' {' + key + ": " + value + "}", dSS[0].cssRules.length);
  }
}

function initBelStyle() {
	// IMPORTANT DIFFERENCE: null means: don't set color, 'null' means: set color to null
  var tmp = null;
	fontFamily = getFontFamily(getCSSProperty(document, '*', 'fontFamily'));
	fontSize = getFontSize(getCSSProperty(document, '*', 'fontSize'));
	fontStyle = nullify(getCSSProperty(document, '*', 'fontStyle'));
	fontWeight = nullify(getCSSProperty(document, '*', 'fontWeight'));
	defaultColor = getWebColor(getCSSProperty(document, '*', 'color'));
	defaultBGColor = getWebColor(getCSSProperty(document, 'body', 'backgroundColor'));
  defaultBorderColor = getWebColor(getCSSProperty(document, 'body', 'borderColor'));
	selectedColor = getWebColor(getCSSProperty(document, '.selected', 'color'));
	if (selectedColor == null) selectedColor = defaultColor;
	selectedBGColor = getWebColor(getCSSProperty(document, '.selected', 'backgroundColor'));
	hoverColor = getWebColor(getCSSProperty(document, '.unselected:hover', 'color'));
	hoverBGColor = getWebColor(getCSSProperty(document, '.unselected:hover', 'backgroundColor'));
	selectedHoverColor = getWebColor(getCSSProperty(document, '.selected:hover', 'color'));
	selectedHoverBGColor = getWebColor(getCSSProperty(document, '.selected:hover', 'backgroundColor'));
	headerColor = getWebColor(getCSSProperty(document, '.header', 'color'));
	if (headerColor == null) headerColor = defaultColor;
	headerBGColor = getWebColor(getCSSProperty(document, '.header', 'backgroundColor'));
	if (headerBGColor == null) headerBGColor = defaultBGColor;
	

	imageViewFontFamily = fontFamily;
	tmp = getFontFamily(getCSSProperty(document, '#imageViewDefault', 'fontFamily'));
	if (tmp != null) imageViewFontFamily = tmp;
	imageViewFontSize = fontSize;
	tmp = getFontSize(getCSSProperty(document, '#imageViewDefault', 'fontSize'));
	if (tmp != null) imageViewFontSize = tmp;
	imageViewFontStyle = fontStyle;
	tmp = nullify(getCSSProperty(document, '#imageViewDefault', 'fontStyle'));
	if (tmp != null) imageViewFontStyle = tmp;
	imageViewFontWeight = fontWeight;
	tmp = nullify(getCSSProperty(document, '#imageViewDefault', 'fontWeight'));
	if (tmp != null) imageViewFontWeight = tmp;
	imageViewColor = defaultColor;
	tmp = getWebColor(getCSSProperty(document, '#imageViewDefault', 'color'));
	if (tmp != null) imageViewColor = tmp;
	imageViewBGColor = defaultBGColor;
	tmp = getWebColor(getCSSProperty(document, '#imageViewDefault', 'backgroundColor'));
	if (tmp != null) imageViewBGColor = tmp;
	overviewBoxColor = headerColor;
	overviewFrameColor = headerColor;
	overviewBoxBorderColor = 'null'; // IMPORTANT DIFFERENCE: null means: don't set color, 'null' means: set color to null
	tmp = getWebColor(getCSSProperty(document, '#imageOverview', 'backgroundColor'));
	if (tmp != null) overviewBoxColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#imageOverview', 'color'));
	if (tmp != null) overviewBoxBorderColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#imageOverview', 'borderColor'));
	if (tmp != null) overviewFrameColor = tmp;
	hintBGColor = selectedBGColor;
	hintColor = null;
	hintTextColor = selectedColor;
	tmp = getWebColor(getCSSProperty(document, '#hint', 'backgroundColor'));
	if (tmp != null) hintBGColor = tmp;

	tmp = getWebColor(getCSSProperty(document, '#hint', 'borderColor'));
	if (tmp != null) hintColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#hint', 'color'));
	if (tmp != null) hintTextColor = tmp;
	hotspotColor = selectedBGColor;

	tmp = getWebColor(getCSSProperty(document, '#hotspot', 'borderColor'));
	if (tmp != null) hotspotColor = tmp;
	hoverHotspotColor = hoverColor;
	tmp = getWebColor(getCSSProperty(document, '#hotspot:hover', 'borderColor'));
	if (tmp != null) hoverHotspotColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#alwaysHotspot', 'borderColor'));
	if (tmp != null) alwaysHotspotColor = tmp

	
	tableFontFamily = fontFamily;
	tmp = getFontFamily(getCSSProperty(document, '#tableDefault', 'fontFamily'));
	if (tmp != null) tableFontFamily = tmp;
	tableFontSize = fontSize;
	tmp = getFontSize(getCSSProperty(document, '#tableDefault', 'fontSize'));
	if (tmp != null) tableFontSize = tmp;
	tableFontStyle = fontStyle;
	tmp = nullify(getCSSProperty(document, '#tableDefault', 'fontStyle'));
	if (tmp != null) tableFontStyle = tmp;
	tableFontWeight = fontWeight;
	tmp = nullify(getCSSProperty(document, '#tableDefault', 'fontWeight'));
	if (tmp != null) tableFontWeight = tmp;
  tableDefaultColor = defaultColor;
	tmp = getWebColor(getCSSProperty(document, '#tableDefault', 'color'));
	if (tmp != null) tableDefaultColor = tmp;
  tableDefaultBGColor = defaultBGColor;
	tmp = getWebColor(getCSSProperty(document, '#tableDefault', 'backgroundColor'));
	if (tmp != null) tableDefaultBGColor = tmp;
  tableSelectedColor = selectedColor;
	tmp = getWebColor(getCSSProperty(document, '#tableSelected', 'color'));
	if (tmp != null) tableSelectedColor = tmp;
  tableSelectedBGColor = selectedBGColor;
	tmp = getWebColor(getCSSProperty(document, '#tableSelected', 'backgroundColor'));
	if (tmp != null) tableSelectedBGColor = tmp;
	tableGridColor = defaultColor;
	tmp = getWebColor(getCSSProperty(document, '#tableDefault', 'borderColor'));
	if (tmp != null) tableGridColor = tmp;
	tableHeaderGridColor = tableGridColor;
	tmp = getWebColor(getCSSProperty(document, '#tableHeader', 'borderColor'));
	if (tmp != null) tableHeaderGridColor = tmp;
  tableHeaderColor = headerColor;
	tmp = getWebColor(getCSSProperty(document, '#tableHeader', 'color'));
	if (tmp != null) tableHeaderColor = tmp;
  tableHeaderBGColor = headerBGColor;
	tmp = getWebColor(getCSSProperty(document, '#tableHeader', 'backgroundColor'));
	if (tmp != null) tableHeaderBGColor = tmp;
	tableTooltipBGColor = selectedBGColor;
	tableTooltipColor = selectedColor;
	tableTooltipTextColor = selectedColor;
	tmp = getWebColor(getCSSProperty(document, '#tableTooltip', 'backgroundColor'));
	if (tmp != null) tableTooltipBGColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#tableTooltip', 'borderColor'));
	if (tmp != null) tableTooltipColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#tableTooltip', 'color'));
	if (tmp != null) tableTooltipTextColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#tableInactiveLine', 'color'));
	if(tmp != null) tableInactiveLineColor = tmp;
	tmp = getWebColor(getCSSProperty(document, '#tableInactiveLine', 'backgroundColor'));
	if(tmp != null) tableInactiveLineBGColor = tmp;
	
	treeFontFamily = fontFamily;
	tmp = getFontFamily(getCSSProperty(document, '#treeDefault', 'fontFamily'));
	if (tmp != null) treeFontFamily = tmp;
	treeFontSize = fontSize;
	tmp = getFontSize(getCSSProperty(document, '#treeDefault', 'fontSize'));
	if (tmp != null) treeFontSize = tmp;
	treeFontStyle = fontStyle;
	tmp = nullify(getCSSProperty(document, '#treeDefault', 'fontStyle'));
	if (tmp != null) treeFontStyle = tmp;
	treeFontWeight = fontWeight;
	tmp = nullify(getCSSProperty(document, '#treeDefault', 'fontWeight'));
	if (tmp != null) treeFontWeight = fontWeight;
  treeDefaultColor = defaultColor;
	tmp = getWebColor(getCSSProperty(document, '#treeDefault', 'color'));
	if (tmp != null) treeDefaultColor = tmp;
  treeDefaultBGColor = defaultBGColor;
	tmp = getWebColor(getCSSProperty(document, '#treeDefault', 'backgroundColor'));
	if (tmp != null) treeDefaultBGColor = tmp;
  treeSelectedColor = selectedColor;
	tmp = getWebColor(getCSSProperty(document, '#treeSelected', 'color'));
	if (tmp != null) treeSelectedColor = tmp;
  treeSelectedBGColor = selectedBGColor;
	tmp = getWebColor(getCSSProperty(document, '#treeSelected', 'backgroundColor'));
	if (tmp != null) treeSelectedBGColor = tmp;
  treeHoverColor = hoverColor;
	tmp = getWebColor(getCSSProperty(document, '#treeDefault:hover', 'color'));
	if (tmp != null) treeHoverColor = tmp;
  treeHoverBGColor = hoverBGColor;
	tmp = getWebColor(getCSSProperty(document, '#treeDefault:hover', 'backgroundColor'));
	if (tmp != null) treeHoverBGColor = tmp;
  treeHoverSelectedColor = selectedColor;
	tmp = getWebColor(getCSSProperty(document, '#treeSelected:hover', 'color'));
	if (tmp != null) treeHoverSelectedColor = tmp;
  treeHoverSelectedBGColor = selectedBGColor;
	tmp = getWebColor(getCSSProperty(document, '#treeSelected:hover', 'backgroundColor'));
	if (tmp != null) treeHoverSelectedBGColor = tmp;
  tmp = nullify(getCSSProperty(document, '#treeDefault', 'backgroundImage'));
  if (tmp != null) {
    if (tmp.indexOf("url(") != -1) {
      treeBackgroundImage = tmp.substring(tmp.indexOf("(")+1,tmp.lastIndexOf(")"));
    }
  }
  tmp = nullify(getCSSProperty(document, '#treeDefault', 'backgroundAttachment'));
  if (tmp != null) {
    treeBackgroundAttachment = (tmp == "fixed") ? "false" : "true";
  }
  tmp = nullify(getCSSProperty(document, '#treeDefault', 'backgroundRepeat'));
  if (tmp != null) {
    treeBackgroundRepeat = (tmp == "no-repeat") ? "false" : "true";
  }    
  
  dividerColor = defaultBorderColor;
  tmp = getWebColor(getCSSProperty(document, '#divider', 'borderColor'));
  if(tmp != null) dividerColor = tmp;
  
	filterFontFamily = tableFontFamily;
	tmp = getFontFamily(getCSSProperty(document, '#filter', 'fontFamily'));
	if (tmp != null) filterFontFamily = tmp;
	filterFontSize = fontSize;
	tmp = getFontSize(getCSSProperty(document, '#filter', 'fontSize'));
	if (tmp != null) filterFontSize = tmp;
	filterFontStyle = fontStyle;
	tmp = nullify(getCSSProperty(document, '#filter', 'fontStyle'));
	if (tmp != null) filterFontStyle = tmp;
	filterFontWeight = fontWeight;
	tmp = nullify(getCSSProperty(document, '#filter', 'fontWeight'));
	if (tmp != null) filterFontWeight = tmp;

  filterBGColor = defaultBGColor;
  tmp = getWebColor(getCSSProperty(document, '#filter', 'backgroundColor'));
	if (tmp != null) filterBGColor = tmp;  
  
  filterButtonBGColor = defaultBGColor;
  tmp = getWebColor(getCSSProperty(document, '.tab', 'backgroundColor'));
  if(tmp != null) filterButtonBGColor = tmp;
  tmp = getWebColor(getCSSProperty(document, '#filterButton', 'backgroundColor'));
	if (tmp != null) filterButtonBGColor = tmp;  
  
  filterHoverBGColor = getWebColor(getCSSProperty(document, 'a', 'backgroundColor')); 
  tmp = getWebColor(getCSSProperty(document, 'a:hover', 'backgroundColor')); 
  if(tmp != null) filterHoverBGColor = tmp;
  tmp = getWebColor(getCSSProperty(document, '#filterButton:hover', 'backgroundColor')); 
  if(tmp != null) filterHoverBGColor = tmp;
  if(filterHoverBGColor == null) filterHoverBGColor = filterButtonBGColor;
  
  filterButtonFGColor = defaultColor;   
  tmp = getWebColor(getCSSProperty(document, '#filterButton', 'color'));
	if (tmp != null) filterButtonFGColor = tmp;  
    
  filterHoverFGColor = getWebColor(getCSSProperty(document, 'a', 'color')); 
  tmp = getWebColor(getCSSProperty(document, 'a:hover', 'color')); 
  if(tmp != null) filterHoverFGColor = tmp;
  tmp = getWebColor(getCSSProperty(document, '#filterButton:hover', 'color')); 
  if(tmp != null) filterHoverFGColor = tmp;
  if(filterHoverFGColor == null) filterHoverFGColor = filterButtonFGColor;
  
//  tmp = nullify(getCSSProperty(document, 'a:hover', 'textDecoration'));
//  filterUnderlineOnHover = (tmp != null) ? "true" : "false";
  tmp = nullify(getCSSProperty(document, '#filterButton:hover', 'textDecoration')); 
  if(tmp != null) filterUnderlineOnHover = "true";  

  filterButtonBorderColor = defaultBorderColor;
  tmp = getWebColor(getCSSProperty(document, '.tab', 'borderColor'));
  if(tmp != null) filterButtonBorderColor = tmp;
  tmp = getWebColor(getCSSProperty(document, '#filterButton', 'borderColor'));
	if (tmp != null) filterButtonBorderColor = tmp;  
  
}

initBelStyle();

function pngTroubleShooting(doc, transparentGif) {
	if(browserName == "Internet Explorer" && (browserMajorVersion >= 6 || (parseInt(browserMajorVersion) == 5 && parseInt(browserMinorVersion) >= 5))) {
		for(var i = 0; i < doc.getElementsByTagName('img').length; i++) {
			var cp = doc.getElementsByTagName('img')[i]; //current pic
			var cache = cp.src.substring(cp.src.length-4,cp.src.length);
			if(cache == ".png") {

				var cps = cp.src; //current pic source
				var cpW = cp.width;
				var cpH = cp.height;
				cp.src=transparentGif;
				cp.style.setAttribute("filter","progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+cps+"', sizingMethod='image')");
				cp.width = cpW;
				cp.height = cpH;
				//alert("replace....\npic-nr.:"+i+"\nnew-src:"+cps+"\nWxH:"+cpW+"x"+cpH);						
			}
		}
	}
}

function getImageViewStyleAppletParams() {
  var styles = new Array();
  var imageViewLabel = "ImageView";
  styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=Font&Value=' + escape(imageViewFontFamily + ';' + getBelFontStyle(imageViewFontStyle, imageViewFontWeight) + ';' + imageViewFontSize);
  if(imageViewColor != null) 
    styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=TextColor&Value=' + escape(imageViewColor);
  if (imageViewBGColor != null)
    styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=Background&Value=' + escape(imageViewBGColor);    
  if (hintTextColor != null)
  	styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=HintTextColor&Value=' + escape(hintTextColor);
  if (hintBGColor != null)
		styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=HintBackgroundColor&Value=' + escape(hintBGColor);
  if (hintColor != null)
	  styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=HintBorderColor&Value=' + escape(hintColor);
  if (overviewBoxColor != null)
	  styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=ImageOverviewBoxColor&Value=' + escape(overviewBoxColor);    
  if (overviewFrameColor != null)
  	styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=ImageOverviewBorderColor&Value=' + escape(overviewFrameColor);  
  if (overviewBoxBorderColor != null)
		styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=ImageOverviewFrameColor&Value=' + escape(overviewBoxBorderColor);
	if (hotspotColor != null)
  	styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=SelectedColor&Value=' + escape(hotspotColor);
 	if (hoverHotspotColor != null)
		styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=HighlightedColor&Value=' + escape(hoverHotspotColor);
 	if (alwaysHotspotColor != null)
		styles[styles.length] = imageViewLabel + ',SetGUIParam,Name=AlwaysVisibleColor&Value=' + escape(alwaysHotspotColor);		

  return styles;
}

function writeImageViewStyleAppletParams(doc, imageViewLabel, paramStart) {
	var guiparam = paramStart;

	doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=Font&Value=' + escape(imageViewFontFamily + ';' + getBelFontStyle(imageViewFontStyle, imageViewFontWeight) + ';' + imageViewFontSize) + '"/>');

	if (imageViewColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=TextColor&Value=' + escape(imageViewColor) + '"/>');
	if (imageViewBGColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=Background&Value=' + escape(imageViewBGColor) + '"/>');

	if (hintTextColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=HintTextColor&Value=' + escape(hintTextColor) + '"/>');
	if (hintBGColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=HintBackgroundColor&Value=' + escape(hintBGColor) + '"/>');
	if (hintColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=HintBorderColor&Value=' + escape(hintColor) + '"/>');

	if (overviewBoxColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=ImageOverviewBoxColor&Value=' + escape(overviewBoxColor) + '"/>');
	if (overviewFrameColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=ImageOverviewBorderColor&Value=' + escape(overviewFrameColor) + '"/>');
	if (overviewBoxBorderColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=ImageOverviewFrameColor&Value=' + escape(overviewBoxBorderColor) + '"/>');

	if (hotspotColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=SelectedColor&Value=' + escape(hotspotColor) + '"/>');
 	if (hoverHotspotColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + imageViewLabel + ',SetGUIParam,Name=HighlightedColor&Value=' + escape(hoverHotspotColor) + '"/>');

	return guiparam;
}

function getTableStyleAppletParams(tableLabel) {
	var styles = new Array();
	styles[styles.length] = tableLabel + ',SetGUIParam,Name=Font&Value=' + escape(tableFontFamily + ';' + getBelFontStyle(tableFontStyle, tableFontWeight) + ';' + tableFontSize);
	if (tableDefaultColor != null)
		styles[styles.length] = tableLabel + ',SetGUIParam,Name=TextColor&Value=' + escape(tableDefaultColor);
	if (tableDefaultBGColor != null)
	    styles[styles.length] = tableLabel + ',SetGUIParam,Name=Background&Value=' + escape(tableDefaultBGColor);
	if (tableSelectedColor != null)
	  	styles[styles.length] = tableLabel + ',SetGUIParam,Name=SelTextColor&Value=' + escape(tableSelectedColor);
	if (tableSelectedBGColor != null)
  		styles[styles.length] = tableLabel + ',SetGUIParam,Name=SelBackground&Value=' + escape(tableSelectedBGColor);
	if (tableGridColor != null)
	  styles[styles.length] = tableLabel + ',SetGUIParam,Name=GridColor&Value=' + escape(tableGridColor);
	if (tableHeaderGridColor != null)
		styles[styles.length] = tableLabel + ',SetGUIParam,Name=HeadGridColor&Value=' + escape(tableHeaderGridColor);
	if (tableHeaderColor != null)
	  	styles[styles.length] = tableLabel + ',SetGUIParam,Name=HeadTextColor&Value=' + escape(tableHeaderColor);
	if (tableHeaderBGColor != null)
	  styles[styles.length] = tableLabel + ',SetGUIParam,Name=HeadBackground&Value=' + escape(tableHeaderBGColor);
	if (tableTooltipColor != null)
	  styles[styles.length] = tableLabel + ',SetGUIParam,Name=TooltipBorderColor&Value=' + escape(tableTooltipColor);
	if (tableTooltipBGColor != null)
	  styles[styles.length] = tableLabel + ',SetGUIParam,Name=TooltipBackground&Value=' + escape(tableTooltipBGColor);
	if (tableTooltipTextColor != null)
	  styles[styles.length] = tableLabel + ',SetGUIParam,Name=TooltipTextColor&Value=' + escape(tableTooltipTextColor);
	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterFont&Value=' + escape(filterFontFamily + ';' + getBelFontStyle(filterFontStyle, filterFontWeight) + ';' + filterFontSize);
	if (filterBGColor != null)
    	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterBackground&Value=' + escape(filterBGColor);
	if (filterHoverBGColor != null)
    	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterHoverBGColor&Value=' + escape(filterHoverBGColor);
	if (filterHoverFGColor != null)
	    styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterHoverFGColor&Value=' + escape(filterHoverFGColor);
	if (filterUnderlineOnHover != null)
    	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterUnderlineOnHover&Value=' + escape(filterUnderlineOnHover);
	if(filterButtonBGColor != null)
    	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterButtonBGColor&Value=' + escape(filterButtonBGColor);
  	if(filterButtonFGColor != null)
    	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterButtonFGColor&Value=' + escape(filterButtonFGColor);
  	if(filterButtonBorderColor != null)
    	styles[styles.length] = tableLabel + ',SetGUIParam,Name=FilterButtonBorderColor&Value=' + escape(filterButtonBorderColor);
  	if(tableInactiveLineColor != null)
  	  	styles[styles.length] = tableLabel + ',SetGUIParam,Name=TextColorOD&Value=' + escape(tableInactiveLineColor);
  	if(tableInactiveLineBGColor != null)
  	  	styles[styles.length] = tableLabel + ',SetGUIParam,Name=BackgroundOD&Value=' + escape(tableInactiveLineBGColor);
  	return styles;
}

function writeTableStyleAppletParams(doc, tableLabel, paramStart) {
	var guiparam = paramStart;

	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=Font&Value=' + escape(tableFontFamily + ';' + getBelFontStyle(tableFontStyle, tableFontWeight) + ';' + tableFontSize) + '"/>');
	if (tableDefaultColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=TextColor&Value=' + escape(tableDefaultColor) + '"/>');
	if (tableDefaultBGColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=Background&Value=' + escape(tableDefaultBGColor) + '"/>');
	if (tableSelectedColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=SelTextColor&Value=' + escape(tableSelectedColor) + '"/>');
	if (tableSelectedBGColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=SelBackground&Value=' + escape(tableSelectedBGColor) + '"/>');

	if (tableGridColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=GridColor&Value=' + escape(tableGridColor) + '"/>');
	if (tableHeaderGridColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=HeadGridColor&Value=' + escape(tableHeaderGridColor) + '"/>');
	if (tableHeaderColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=HeadTextColor&Value=' + escape(tableHeaderColor) + '"/>');
	if (tableHeaderBGColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=HeadBackground&Value=' + escape(tableHeaderBGColor) + '"/>');

	if (tableTooltipColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=TooltipBorderColor&Value=' + escape(tableTooltipColor) + '"/>');
	if (tableTooltipBGColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=TooltipBackground&Value=' + escape(tableTooltipBGColor) + '"/>');
	if (tableTooltipTextColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=TooltipTextColor&Value=' + escape(tableTooltipTextColor) + '"/>');

	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterFont&Value=' + escape(filterFontFamily + ';' + getBelFontStyle(filterFontStyle, filterFontWeight) + ';' + filterFontSize) + '">');
	if (filterBGColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterBackground&Value=' + escape(filterBGColor) + '">');
	if (filterHoverBGColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterHoverBGColor&Value=' + escape(filterHoverBGColor) + '">');
	if (filterHoverFGColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterHoverFGColor&Value=' + escape(filterHoverFGColor) + '">');
	if (filterUnderlineOnHover != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterUnderlineOnHover&Value=' + escape(filterUnderlineOnHover) + '">');        
	if(filterButtonBGColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterButtonBGColor&Value=' + escape(filterButtonBGColor) + '">');
  	if(filterButtonFGColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterButtonFGColor&Value=' + escape(filterButtonFGColor) + '">');
  	if(filterButtonBorderColor != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=FilterButtonBorderColor&Value=' + escape(filterButtonBorderColor) + '">');
  	
  	if(tableInactiveLineColor != null)
  	  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=TextColorOD&Value=' + escape(tableInactiveLineColor) + '">');
  	if(tableInactiveLineBGColor != null)
  	  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + tableLabel + ',SetGUIParam,Name=BackgroundOD&Value=' + escape(tableInactiveLineBGColor) + '">');
  	
	return guiparam;
}

function getTreeStyleAppletParams() {
	var styles = new Array();
	var treeLabel = "Tree";
	styles[styles.length] = treeLabel + ',SetGUIParam,Name=Font&Value=' + escape(treeFontFamily + ';' + getBelFontStyle(treeFontStyle, treeFontWeight) + ';' + treeFontSize);
	if (treeDefaultColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=TextColor&Value=' + escape(treeDefaultColor);
	if (treeDefaultBGColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=Background&Value=' + escape(treeDefaultBGColor);
	if (treeSelectedColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=SelectedTextColor&Value=' + escape(treeSelectedColor);
	if (treeSelectedBGColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=SelectedColor&Value=' + escape(treeSelectedBGColor);
	if (treeHoverColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=MouseOverTextColor&Value=' + escape(treeHoverColor);
	if (treeHoverBGColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=MouseOverColor&Value=' + escape(treeHoverBGColor);
	if (treeHoverSelectedColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=MouseOverSelectedTextColor&Value=' + escape(treeHoverSelectedColor);
	if (treeHoverSelectedBGColor != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=MouseOverSelectedColor&Value=' + escape(treeHoverSelectedBGColor);
	if(treeBackgroundImage != null) 
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=BackgroundImage&Value=' + escape(treeBackgroundImage);
	if(treeBackgroundAttachment != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=ScrollBackground&Value=' + escape(treeBackgroundAttachment);
	if(treeBackgroundRepeat != null)
		styles[styles.length] = treeLabel + ',SetGUIParam,Name=TileBackground&Value=' + escape(treeBackgroundRepeat);
	return styles;
}

// deprecated
// @see => getTreeStyleAppletParams()
function writeTreeStyleAppletParams(doc, treeLabel, paramStart) { 
	var guiparam = paramStart;
	doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=Font&Value=' + escape(treeFontFamily + ';' + getBelFontStyle(treeFontStyle, treeFontWeight) + ';' + treeFontSize) + '"/>');

	if (treeDefaultColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=TextColor&Value=' + escape(treeDefaultColor) + '"/>');
	if (treeDefaultBGColor != null)
	  doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=Background&Value=' + escape(treeDefaultBGColor) + '"/>');

	if (treeSelectedColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=SelectedTextColor&Value=' + escape(treeSelectedColor) + '"/>');
	if (treeSelectedBGColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=SelectedColor&Value=' + escape(treeSelectedBGColor) + '"/>');

	if (treeHoverColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=MouseOverTextColor&Value=' + escape(treeHoverColor) + '"/>');
	if (treeHoverBGColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=MouseOverColor&Value=' + escape(treeHoverBGColor) + '"/>');

	if (treeHoverSelectedColor != null)
  	doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=MouseOverSelectedTextColor&Value=' + escape(treeHoverSelectedColor) + '"/>');
	if (treeHoverSelectedBGColor != null)
		doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=MouseOverSelectedColor&Value=' + escape(treeHoverSelectedBGColor) + '"/>');

  if(treeBackgroundImage != null) 
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=BackgroundImage&Value=' + escape(treeBackgroundImage) + '"/>');
  if(treeBackgroundAttachment != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=ScrollBackground&Value=' + escape(treeBackgroundAttachment) + '"/>');
  if(treeBackgroundRepeat != null)
    doc.writeln('<param name="Message' + guiparam++ + '" value="' + treeLabel + ',SetGUIParam,Name=TileBackground&Value=' + escape(treeBackgroundRepeat) + '"/>');    
    
	return guiparam;
}
